<?php
/**
 * @file
 * blend_core.features.inc
 */

/**
 * Implements hook_ctools_plugin_api().
 */
function blend_core_ctools_plugin_api($module = NULL, $api = NULL) {
  if ($module == "context" && $api == "context") {
    return array("version" => "3");
  }
  if ($module == "file_entity" && $api == "file_type") {
    return array("version" => "1");
  }
}

/**
 * Implements hook_image_default_styles().
 */
function blend_core_image_default_styles() {
  $styles = array();

  // Exported image style: portfolio.
  $styles['portfolio'] = array(
    'label' => 'Portfolio',
    'effects' => array(
      3 => array(
        'name' => 'image_scale_and_crop',
        'data' => array(
          'width' => 560,
          'height' => 420,
        ),
        'weight' => 1,
      ),
    ),
  );

  return $styles;
}

/**
 * Implements hook_default_mailchimp_signup().
 */
function blend_core_default_mailchimp_signup() {
  $items = array();
  $items['newsletter_signup'] = entity_import('mailchimp_signup', '{
    "name" : "newsletter_signup",
    "mc_lists" : { "94b0e94cea" : "94b0e94cea" },
    "mode" : "1",
    "title" : "MAILCHIMP SIGNUP",
    "settings" : {
      "path" : "",
      "submit_button" : "SIGN UP",
      "confirmation_message" : "You have been successfully subscribed.",
      "destination" : "",
      "mergefields" : {
        "EMAIL" : {
          "name" : "Email Address",
          "req" : true,
          "field_type" : "email",
          "public" : true,
          "show" : true,
          "order" : "1",
          "default" : null,
          "helptext" : null,
          "size" : "25",
          "tag" : "EMAIL",
          "id" : 0
        },
        "FNAME" : 0,
        "LNAME" : 0
      },
      "description" : "Blend porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci.",
      "doublein" : 0,
      "send_welcome" : 1,
      "include_interest_groups" : 1
    },
    "rdf_mapping" : []
  }');
  return $items;
}

/**
 * Implements hook_node_info().
 */
function blend_core_node_info() {
  $items = array(
    'webform' => array(
      'name' => t('Webform'),
      'base' => 'node_content',
      'description' => t('Create a new form or questionnaire accessible to users. Submission results and statistics are recorded and accessible to privileged users.'),
      'has_title' => '1',
      'title_label' => t('Title'),
      'help' => '',
    ),
  );
  drupal_alter('node_info', $items);
  return $items;
}
