(function ($) {
  Drupal.behaviors.blend_theme = {
    attach: function (context, settings) {
	  $('.search-toggle').once('search', function () {
        $(this).click(function () {
          $('body').toggleClass('search-open');
        });
      });
      /* Fix column sibling height */
      $(".data-height-fix").each(function () {
        var siblingHeight = $(this).find($(".get-height")).outerHeight();
        $(".set-height").css("height", siblingHeight);
      });
      $("a[rel^='prettyPhoto']").prettyPhoto();
      /* Tooltips */
      if ($().tooltip) {
        $("[data-toggle='tooltip']").tooltip();
      }
      /* Popovers */
      if ($().popover) {
        $("[data-toggle='popover']").popover();
      }
      Drupal.settings.blend = Drupal.settings.blend  || {};
      Drupal.settings.blend.header_overlay_logo = Drupal.settings.blend.header_overlay_logo || '';
      if(Drupal.settings.blend.header_overlay_logo != '' && $('body').hasClass('header-overlay')){
        $('a.site-logo').once('logo',function(){
          $('a.site-logo img').addClass('primary');
          $(this).append('<img class="secondary" src="'+Drupal.settings.blend.header_overlay_logo+'"/>');
        });
      }
    }
  }
  var equalizer = function() {
    $(".equalizer").each(function () {
      var getHeight = $(this).find($(".get-height")).height();
      $(".set-height").css("height", getHeight);
    });
  }
  $(window).load(function () {
    equalizer();
    $(".loader").delay(600).fadeOut("slow");
  });
  setTimeout(function(){
    $(".loader").delay(600).fadeOut("slow");
  },10000);
})(jQuery);

jQuery(document).ready(function ($) {
    "use strict";
    
    /*Mail chimp text value default*/
    $(".mailchimp-signup-subscribe-form input[name='mergevars[EMAIL]']").val("E-mail Address");
    
    /*Go to top*/
    $(window).scroll(function () {
        if ($(this).scrollTop() > 100) {
            $('#go-to-top').css({
                bottom: "-1px"
            });
        } else {
            $('#go-to-top').css({
                bottom: "-100px"
            });
        }
    });
    $('#go-to-top').click(function () {
        $('html, body').animate({
            scrollTop: '0px'
        }, 800);
        return false;
    });
});
