<?php

require_once dirname(__FILE__) . '/lessc.inc.php';

class drupalexp_lessc {

  var $theme;
  var $output;
  var $css;
  var $lessc;
  var $importDir;
  var $fonts;
  var $google_fonts = array();

  function __construct($theme) {
    $this->theme = $theme;
    $this->lessc = new lessc();
    //$this->lessc->setImportDir(drupal_get_path('theme', $theme->theme));
    $this->lessc->setImportDir(DRUPAL_ROOT);
    //$this->importDir = drupal_get_path('theme', $theme->theme);
    $this->importDir = DRUPAL_ROOT;
    $this->__addPresetVariables();
    $this->__addBaseCSS();
  }

  function addVariable($name, $value) {
    $this->output .= "@{$name}:{$value};\n";
  }

  function filetime($file) {
    if (($time = @filemtime($file)) != FALSE) {
      return $time;
    }
    if (($time = @filemtime($this->importDir . '/' . $file)) != FALSE) {
      return $time;
    }
    return 0;
  }

  function complie($file = null) {
    $update = false;
    $theme_path = drupal_get_path('theme', $this->theme->theme);
    $assets_path = file_create_url($theme_path.'/assets');
    $drupalexp_assets = variable_get('drupalexp_assets_path','');
    if($drupalexp_assets != $assets_path){
      $update = true;
      variable_set('drupalexp_assets_path',$assets_path);
    }
    $ftime = $this->filetime($file);
    if (!empty($this->theme->lessc)) {
      foreach($this->theme->lessc as $theme => $lessc){
        $theme_path = drupal_get_path('theme', $theme);
        foreach($lessc as $less){
          $lessc_file = $theme_path."/".$less;
          if ($ftime < $this->filetime($lessc_file)) {
            $update = true;
          }
          $this->output .= "@import \"$lessc_file\";\n";
        }
      }
      /*foreach ($this->theme->lessc as $lessc_file) {
        if ($ftime < $this->filetime($lessc_file)) {
          $update = true;
        }
        $this->output .= "@import \"$lessc_file\";\n";
      }*/
    }
    if ($update) {
      $this->__setupFonts();
      if(!empty($this->google_fonts)){
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http';
        $this->output = '@import url('.$protocol.'://fonts.googleapis.com/css?family='.implode('|',$this->google_fonts).');' . $this->output;
      }
      try {
        $this->css = $this->lessc->compile($this->output);
      } catch (exception $e) {
        drupal_set_message("fatal error: " . $e->getMessage(), 'error');
        return FALSE;
      }
      if ($file) {
        $css_output = "/*This file is generated by less css (http://lesscss.org) using drupalexp framework (http://drupalexp.com)*/\n/*Please do not modify this file content*/\n" . $this->css;
        $css_output = str_replace(array('../'),$assets_path.'/',$css_output);
        file_unmanaged_save_data($css_output, $file, FILE_EXISTS_REPLACE);
      }
    }
    return $this->css;
  }

  private function __addPresetVariables() {
    foreach ($this->theme->lessc_vars as $key => $value) {
      $this->addVariable($key, $value);
    }
  }

  private function __addBaseCSS() {
      $this->output .= 'body{color: @text_color;}a:not(.btn){color:@link_color; &:hover{color:@link_hover_color}}h1,h2,h3,h4,h5,h6{color:@heading_color}';
  }
  private function __setupFonts() {
    $elements = array('body','h1','h2','h3','h4','h5','h6','custom_font_1','custom_font_2','custom_font_3','custom_font_4','custom_font_5');
    foreach($elements as $element){
      $this->__setupFont($element);
    }
  }
  private function __setupFont($element) {
    if(empty($this->fonts)){
      $fonts = json_decode(file_get_contents(__DIR__.'/font-list.json'));
      foreach($fonts->items as $k=>$font){
        $fonts->items[$k]->label = $font->family;
        $fonts->items[$k]->value = $font->family;
        if(!isset($fonts->items[$k]->{'data-google'})){
          $fonts->items[$k]->{'data-google'} = 1;
        }
      }
      $this->fonts = $fonts->items;
    }
    $font = theme_get_setting($element);
    if(!empty($font)){
      $font_arr = explode(':', $font,5);
      if(empty($font_arr[0])) return false;
      if(strpos($element,'custom_font') !== false && empty($font_arr[4])) return false;
      $font = drupalexp_getfont($font_arr[0]);
      if($font->{'data-google'} == 1){
        $this->google_fonts[] = str_replace(' ','+',$font_arr[0]) . ':' . $font_arr[1];
      }
      $css = array();
      $selector = $element;
      if($font->{'data-google'} != 1){
        $css[] = "font-family:{$font->family};";
      }elseif(isset($font->{'font-family'})){
        $css[] = "font-family:{$font->{'font-family'}};";
      }else{
        $css[] = "font-family:\"{$font_arr[0]}\";";
      }
      if(strpos($font_arr[1],'italic') !== false){
        $css[] = "font-style: italic;";
        $font_arr[1] = str_replace('italic','',$font_arr[1]);
        if(!empty($font_arr[1])){
          $css[] = "font-weight: {$font_arr[1]};";
        }
      }elseif($font_arr[1]== 'regular'){
        $css[] = "font-weight: 400;";
      }else{
        $css[] = "font-weight: {$font_arr[1]};";
      }
      if(isset($font_arr[2]) && !empty($font_arr[2])){
        $css[] = "font-size: $font_arr[2];";
      }
      if(isset($font_arr[3]) && !empty($font_arr[3])){
        $css[] = "line-height: $font_arr[3];";
      }
      if(isset($font_arr[4]) && !empty($font_arr[4])){
        $selector = $font_arr[4];
      }
      $this->output .= $selector . '{'.implode('',$css).'}';
    }
  }
}

/*Fonts helper*/
function drupalexp_getfont($family){
  $drupal_static = &drupal_static(__FUNCTION__);
  if (!isset($drupal_static['drupalexp_fonts'])) {
    $fonts = json_decode(file_get_contents(__DIR__.'/font-list.json'));
    foreach($fonts->items as $k=>$font){
      $fonts->items[$k]->label = $font->family;
      $fonts->items[$k]->value = $font->family;
      if(!isset($fonts->items[$k]->{'data-google'})){
        $fonts->items[$k]->{'data-google'} = 1;
      }
    }
    $drupal_static['drupalexp_fonts'] = $fonts;
  }else{
    $fonts = $drupal_static['drupalexp_fonts'];
  }
  foreach($fonts->items as $font){
    if($font->family == $family){
      return $font;
    }
  }
  $font = new stdClass();
  $font->family = $family;
  $font->{'data-google'} = 0;
  return $font;
}
