<?php

function blend_init_presets(){
  return 8;
}

function blend_default_layouts(){
  return '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';
}

function blend_default_presets(){
  return 'W3sia2V5IjoiQnVzaW5lc3MiLCJiYXNlX2NvbG9yIjoiIzMyOTZEQyIsInRleHRfY29sb3IiOiIjNzc3Nzc3IiwibGlua19jb2xvciI6IiMzMjk2REMiLCJsaW5rX2hvdmVyX2NvbG9yIjoiIzNjM2MzYyIsImhlYWRpbmdfY29sb3IiOiIjM2MzYzNjIiwiYmFzZV9jb2xvcl9vcHBvc2l0ZSI6IiMzMjk2REMifSx7ImtleSI6IkN5YW4iLCJiYXNlX2NvbG9yIjoiIzViYmZjNSIsInRleHRfY29sb3IiOiIjOTk5OTk5IiwibGlua19jb2xvciI6IiM1YmJmYzUiLCJsaW5rX2hvdmVyX2NvbG9yIjoiIzQ5NGM1MCIsImhlYWRpbmdfY29sb3IiOiIjMDAwMDAwIiwiYmFzZV9jb2xvcl9vcHBvc2l0ZSI6IiM1YmJmYzUifSx7ImtleSI6Ik1lZGljYWwiLCJiYXNlX2NvbG9yIjoiIzE4RTJCQSIsInRleHRfY29sb3IiOiIjOTk5OTk5IiwibGlua19jb2xvciI6IiMxOEUyQkEiLCJsaW5rX2hvdmVyX2NvbG9yIjoiIzQ5NGM1MCIsImhlYWRpbmdfY29sb3IiOiIjMDAwMDAwIiwiYmFzZV9jb2xvcl9vcHBvc2l0ZSI6IiMxOEUyQkEifSx7ImtleSI6IlJlc3RhdXJhbnQiLCJiYXNlX2NvbG9yIjoiI0ZGMDAwMCIsInRleHRfY29sb3IiOiIjOTk5OTk5IiwibGlua19jb2xvciI6IiNGRjAwMDAiLCJsaW5rX2hvdmVyX2NvbG9yIjoiIzQ5NGM1MCIsImhlYWRpbmdfY29sb3IiOiIjMDAwMDAwIiwiYmFzZV9jb2xvcl9vcHBvc2l0ZSI6IiNGRjAwMDAifSx7ImtleSI6IlBvcnRmb2xpbyIsImJhc2VfY29sb3IiOiIjZmJhNjI4IiwidGV4dF9jb2xvciI6IiM5OTk5OTkiLCJsaW5rX2NvbG9yIjoiI2ZiYTYyOCIsImxpbmtfaG92ZXJfY29sb3IiOiIjNDk0YzUwIiwiaGVhZGluZ19jb2xvciI6IiMwMDAwMDAiLCJiYXNlX2NvbG9yX29wcG9zaXRlIjoiI2ZiYTYyOCJ9LHsia2V5IjoiT3JhbmdlIiwiYmFzZV9jb2xvciI6IiNmZjg4MzMiLCJ0ZXh0X2NvbG9yIjoiIzk5OTk5OSIsImxpbmtfY29sb3IiOiIjZmY4ODMzIiwibGlua19ob3Zlcl9jb2xvciI6IiM0OTRjNTAiLCJoZWFkaW5nX2NvbG9yIjoiIzAwMDAwMCIsImJhc2VfY29sb3Jfb3Bwb3NpdGUiOiIjZmY4ODMzIn0seyJrZXkiOiJUYW5nZXJpbmUiLCJiYXNlX2NvbG9yIjoiI2UyNDkyZiIsImJhc2VfY29sb3Jfb3Bwb3NpdGUiOiIjZTI0OTJmIiwibGlua19jb2xvciI6IiNlMjQ5MmYiLCJsaW5rX2hvdmVyX2NvbG9yIjoiIzQ5NGM1MCIsInRleHRfY29sb3IiOiIjOTk5OTk5IiwiaGVhZGluZ19jb2xvciI6IiMwMDAwMDAifSx7ImtleSI6IkdvbGQiLCJiYXNlX2NvbG9yIjoiI2M3OWM2MCIsImJhc2VfY29sb3Jfb3Bwb3NpdGUiOiIjYzc5YzYwIiwibGlua19jb2xvciI6IiNjNzljNjAiLCJsaW5rX2hvdmVyX2NvbG9yIjoiIzQ5NGM1MCIsInRleHRfY29sb3IiOiIjOTk5OTk5IiwiaGVhZGluZ19jb2xvciI6IiMwMDAwMDAifV0=';
}

/**
 * Define which elements
 */
function blend_fonts_set(){
  return array('body','h1','h2','h3','h4','h5','h6','h1#page-title','h2.block-title');
}

/**
 * hook_preprocess_node
 */
function blend_preprocess_node(&$variables) {
  $node = $variables['node'];
  // Display post information only on certain node types.
  if ($node->type == "article") {
    if (isset($node->field_blog_categories)) {
      $categories = blend_format_comma_field('field_blog_categories', $node);
      $variables['blog_categories'] = $categories;
    }
    if (isset($node->field_tags)) {
      $tags = blend_format_comma_field('field_tags', $node);
      $variables['blog_tags'] = $tags;
    }
  }
}

/**
 * Implement hook_form_search_block_form_alter().
 */
function blend_form_search_block_form_alter(&$form) {
  $form['search_block_form']['#attributes']['placeholder'] = t('What are you looking for?');
  //$form['actions']['#attributes']['class'][] = 'element-invisible';
}
function blend_form_search_form_alter(&$form) {
  $form['search_form']['#attributes']['placeholder'] = t('What are you looking for?');
  //$form['actions']['#attributes']['class'][] = 'element-invisible';
}

function blend_format_comma_field($field_category, $node, $limit = NULL) {
  $category_arr = array();
  $field = field_get_items('node', $node, $field_category);
  if (!empty($field)) {
    foreach ($field as $item) {
      $term = taxonomy_term_load($item['tid']);
      if ($term) {
        if (module_exists('i18n_taxonomy')) {
          $term_name = i18n_taxonomy_term_name($term, $node->language);
        } else {
          $term_name = $term->name;
        }
        $category_arr[] = l($term_name, 'taxonomy/term/' . $item['tid']);
      }
      if ($limit) {
        if (count($category_arr) == $limit) {
          $category = implode(', ', $category_arr);
          return $category;
        }
      }
    }
  }
  $category = implode(', ', $category_arr);
  return $category;  
}

/**
 * Improve HTML Validator
 */
function blend_preprocess_image(&$vars) {
    if (!isset($vars['attributes']['alt'])) {
        $vars['attributes']['alt'] = '';
    }
}
function blend_preprocess_html(&$vars) {
  $header_overlay_logo = theme_get_setting('header_overlay_logo');
  $header_style = theme_get_setting('header_style');
  $header_style_opacity = theme_get_setting('header_overlay_opacity');
  $footer_style = theme_get_setting('footer_style');
  $vars['classes_array'][] = $footer_style;
  drupal_add_css('body.header-overlay #section-header .section-inner{background-color:rgba(255,255,255,'.$header_style_opacity.')}','inline');
  if(!empty($header_style)){
    $vars['classes_array'][] = $header_style;
  }else{
    $node = menu_get_object('node');
    if($node && $node->type=='page'){
      if(field_get_items('node', $node, 'field_image')){
        $vars['classes_array'][] = 'header-overlay';
      }
    }
  }
  if(empty($header_overlay_logo)) $header_overlay_logo = '';
  else{
    $header_overlay_logo = file_create_url($header_overlay_logo);
  }
  drupal_add_js(array('blend'=>array('header_overlay_logo'=>$header_overlay_logo)),'setting');
}

/**
 * Implement hook_form_comment_form_alter().
 */
function blend_form_comment_form_alter(&$form, &$form_state, $form_id) {
  $form['actions']['submit']['#attributes']['class'][]= 'dexp-shortcodes-button btn btn-primary';
  $form['actions']['submit']['#attributes']['value']= 'POST COMMENT';
}

/**
 * Implement breadcrumb().
 */
function blend_breadcrumb($variables) {
  // Convenience variable:
  $breadcrumb = $variables['breadcrumb'];
  $breadcrumb[] = drupal_get_title();
  // If we have any breadcrumbs:
  if (!empty($breadcrumb) && (count($breadcrumb) > 1)) {
    // Convert 'em to a string:
    $breadcrumbs = implode(' <span class="divider">&rarr;</span> ', $breadcrumb);
    // Build a heading--here at least, we're following the D7 convention of
    // accompanying menus with invisible headings to aid in text-only navigation:
    $heading = t('You are here');
    // Pattern for output:
    $output_pattern = '<h2 class="element-invisible">%s</h2><ul class="breadcrumb"><li>%s</li></ul>';
    // Return the markup:
    return sprintf($output_pattern, $heading, $breadcrumbs);
  }
}

function blend_preprocess_section(&$vars) {
  if($vars['section']->key == 'page-title'){
    $blocks = block_get_blocks_by_region('banner');
    if($blocks){
      $vars['attributes_array']['class'][] = 'has-banner';
    }
  }
}
