<?php

function dexp_shortcodes_stats_shortcode_info(&$shortcodes) {
  $shortcodes['stats'] = array(
      'title' => t('Stats'),
      'description' => t('Js Stats shortcode'),
      'process callback' => 'dexp_shortcodes_stats',
      'tips callback' => 'dexp_shortcodes_stats_tips',
  );
}

function dexp_shortcodes_stats($attrs, $text) {
  $attrs = shortcode_attrs(array(
      'class' => '',
      'icon' => '',
      'timer' => '',
	  'start_number'=>'0',
	  'inc_step'=>'1',
	  'speed'=>'1',
      'number' => ''), $attrs);
  $attrs['content'] = $text;
  return trim(theme('dexp_shortcodes_stats', $attrs));
}

function dexp_shortcodes_stats_theme(&$themes) {
  $path = drupal_get_path('module', 'dexp_shortcodes');
  $themes['dexp_shortcodes_stats'] = array(
      'template' => 'stats',
      'path' => $path . '/theme',
      'pattern' => 'shortcode__',
      'preprocess functions' => array(
          'template_preprocess',
          'dexp_shortcodes_preprocess_shortcode_stats',
      ),
      'variables' => array(
          'class' => '',
          'icon' => '',
          'timer' => '',
		  'start_number'=>'0',
		  'inc_step'=>'1',
	      'speed'=>'1',
          'number' => '',
          'content' => '',
      )
  );
}

function dexp_shortcodes_preprocess_shortcode_stats(&$vars) {
  $vars['stats_id'] = drupal_html_id("dexp_stats_".REQUEST_TIME);
  $vars['theme_hook_suggestions'][] = 'shortcode__stats';
}

function dexp_shortcodes_stats_tips($format,$long) {
  $output = "[stats number='' start_number='0' inc_step='1' speed='1' icon='' class='']Title[/stats]";
  return $output;
}